### 概述

本产品是一个控制工具库，提供多种控制和信号处理的功能块。该库涵盖了常见的控制算法、滤波器、信号发生器及其他实用工具，适用于自动化控制、信号处理和系统测试等领域。下表概述了各个产品组件

| **产品组件**                         | **描述说明**                     |
| -------------------------------- | ---------------------------- |
| **Controller**                   |                              |
| FB\_3Point                       | 三点控制器                        |
| FB\_3PointExt                    | 扩展的三点控制器                     |
| FB\_P                            | P控制器                         |
| FB\_PI                           | PI控制器                        |
| FB\_PID                          | PID控制器                       |
| FB\_PIDSplitRange                | 可在线切换参数的PID控制器               |
| FB\_PIDExtSplitRange             | 扩展的PID控制器，增加了输入和输出死区等功能      |
| FB\_PIDSplitRangeParameterSwitch | 用于FB\_PIDSplitRange控制器的参数切换  |
| **MC**                           |                              |
| FB\_CoERead                      | 读取CoE PDO                    |
| FB\_CoEReset                     |                              |
| MC\_CoEReset                     |                              |
| MC\_ResetECError                 |                              |
| **Output to Control Equipment**  |                              |
| FB\_DeadBand                     | 对输入信号提供一个死区                  |
| FB\_Limiter                      | 输出信号限制                       |
| FB\_PWMOut                       | 基于输入信号提供PWM输出                |
| FB\_PWMOutExt                    | 扩展的PWM功能                     |
| **Signal**                       |                              |
| FB\_NoiseGenerator               | 噪音信号发生器                      |
| FB\_Ramp                         | 斜坡信号发生器                      |
| FB\_Random                       | 随机数发生器                       |
| FB\_SetPointGenerator            | 设定值发生器，根据输入序列提供输出            |
| FB\_SignalGenerator              | 信号发生器，提供正弦波，方波，三角波和锯齿波       |
| **SignalProcess**                |                              |
| FB\_DigitalFilter                | 数字量滤波器的基础功能，可实现FIR滤波器或IIR滤波器 |
| FB\_MovingAverageFilter          | 移动均值滤波器                      |
| FB\_NotchFilter                  | 陷波滤波器                        |
| FB\_PT1                          | PT1滤波器                       |
| FB\_PT2                          | PT2滤波器                       |
| FB\_PTn                          | PTn滤波器                       |

---
### 安装卸载

**安装要求**

本节描述工程和/或运行时系统所需的最低要求。

**1、硬件要求**

支持 MetaFacture 平台的设备（ PLC 或嵌入式系统）。

**2、软件要求**

已安装 MetaFacture 的开发环境。

操作系统支持：MetaOS或其他兼容平台。

必须具备相关的库或模块依赖（如基础 I/O 库）

**安装过程**

在 MetaFacture 中打开工程项目。

通过菜单选择“工具”->“库存储”。
![](https://resource.helplook.net/docker_production/3648ne/article/wIkNP2OF/680ef3fe9e31d.png)


点击安装，打&#x5F00;**&#x20;ControlToolBox.compiled-library** 库文件。
![](https://resource.helplook.net/docker_production/3648ne/article/wIkNP2OF/680ef40cceef6.jpg)

![](https://resource.helplook.net/docker_production/3648ne/article/wIkNP2OF/680ef412ad9f6.jpg)


打开成功，关闭窗口。

点击”添加库“
![](https://resource.helplook.net/docker_production/3648ne/article/wIkNP2OF/680ef41bc2d1d.png)


选&#x4E2D;**&#x20;ControlToolBox&#x20;**，点击确&#x5B9A;**。**
![](https://resource.helplook.net/docker_production/3648ne/article/wIkNP2OF/680ef42b7644b.png)


**更新安装**

**1、覆盖安装**

下载最新版本的 ControlToolBo&#x78;**&#x20;**&#x5E93;文件。

打开 MetaFacture 工程，在“库管理器”中删除旧版本的库，导入新版本库文件。

保存工程并重新编译。

**2、版本兼容性验证**

检查新版本是否与现有工程兼容（例如检查参数和接口）。

根据文档调整旧版本与新版本可能的差异。

**卸载过程**

**1、通过库管理器卸载**

打开 MetaFacture 项目，进入“库管理器”。

选择 ControlToolBox 库，点击“删除库”卸载库文件。![](https://resource.helplook.net/docker_production/3648ne/article/wIkNP2OF/680ef4bec3b7b.jpg)



2、**清理项目依赖**

打开工程项目，检查并移除所有使用 ControlToolBox 库的功能块或接口。

确保工程重新编译时无报错。